/////////////////////////////////////////////////////////////////////////// 
//                             scorpio5_awd.c                            //     
//                         James Austin  11.09.02                        //     
///////////////////////////////////////////////////////////////////////////
//                                                                       //
//  Test program for Audible warning Lock/Open on Ford Scorpio 1995+     //
//                    Code for CCS PCM C Compiler                        //
//                                                                       //
//IO: RB1 Digital input from Heated Mirrors Fuse, active originally when //
//         Heated rear screen is pressed.                                //
//    RB3 Digital output for aux on CN2 to switch headlamps, horn etc    //
//    RB4 Digital output for piezo transducer                            //
//          (with no internal drive circuit)                             //
//    RA0 Analogue input to monitor battery voltage                      //
//    RA1 Analogue input to monitor CT on lock system                    //
//                                                                       //
//Variables:                                                             //
//    BattVolt Not used yet                                              //
//    DoorRef  Value from CT (256 = 5V)                                  //
//    x        General global counter                                    //
//    Blip     Tone duration                                             //
//                                                                       //
//Functions:                                                             //
//    main     Sets up adc, monitors CT, generates tone durations,       //  
//             switches aux                                              //
//    HighBlip generates tone on CN3                                     //   
//                                                                       //
//        Ref from CT is 2.5V with no current and reduces with current   //
//            relationship is linear, values depend on model of CT       //
//                          refer to data sheets etc                     //
//        Add code to distinguish between lock/deadlock/boot etc         //
//        This code here activates 3 chirps (blip...blip....Bleep)       //
//                      for any lock/unlock action                       //
//                                                                       //
//   NO WARRANTIES, GUARANTIES OR PROMISES GIVEN ABOUT CODE OR HARDWARE  //
//                      DIY EXPERIMENTAL USE ONLY                        //
//                                                                       //
///////////////////////////////////////////////////////////////////////////               
//                                                                       //        
//Revisions:                                                             //
//    Time taken to complete beep cycle shortened, as to allow AWD to    //
//           respond reliably on dead lock  (within 3 sec)               //
///////////////////////////////////////////////////////////////////////////


#include <16c71.H> 
#use delay (clock=4000000,RESTART_WDT)
#fuses HS,WDT,PUT                      //highspeed, watchdog, power up timer fuses

void HighBlip(void);

int  BattVolt = 0, DoorRef = 0;
long x = 0, Blip = 0;



main() 
 
 {
  setup_port_a(RA0_RA1_ANALOG); // PIN 17 & 18 ANALOGUE
  setup_adc(ADC_CLOCK_INTERNAL);//set adc to internal ref's
  restart_wdt();
  delay_ms(10);
  set_adc_channel (1);          //adc set for CT ref
  delay_ms(10);
  output_low(PIN_B3);           //ensure aux output on CN2 is off
  restart_wdt();

  do                            //do while true loop..always loop here
   {
    restart_wdt();
    DoorRef = read_ADC();       //get value from CT
    delay_ms(10);
    restart_wdt();

    if(DoorRef < 120)           //if CT detects current 120 = aprox 2.3V from CT
     {                          //delay for motor start up current
      Delay_ms(50);
      restart_wdt(); 
                                
                                //add different if statements for different CT values here

      if(DoorRef <= 115)        //if CT ref is less than 2.2V 
       {                        //do this
        restart_wdt();
        output_high(PIN_B3);    //turn on aux output on CN2
        Blip = 100;             //set blip length
        HighBlip();             //call HighBlip tone generator function
        Delay_ms(100);
        output_low(PIN_B3);     //turn off aux
        restart_wdt();
        Blip = 100;
        HighBlip();
        Delay_ms(150);
        output_high(PIN_B3);
        restart_wdt();
        Blip = 700;
        HighBlip(); 
        restart_wdt();
        delay_ms(150);
        restart_wdt();
        output_low(PIN_B3);
       }

      }
    }
   while(TRUE);
      


 }

//tone generator function to drive Piezo transducer on CN3

HighBlip(void)

 {
  x = 0;
  while(x < Blip)
   {
    x = ++x;
    restart_wdt();
    output_high(PIN_B4);   
    delay_us(120);
    restart_wdt();
    output_low(PIN_B4);
    delay_us(120);
    restart_wdt();
   }
   delay_ms(10);
   
 }




